
#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#include <ESP8266WiFi.h>
#include <WiFiClient.h>
#include <ArduinoOTA.h>                         // Arduino OTA von Arduino, Juraj Andrassy

#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>                       // Adafruit GFX library von Adafruit
#include <Adafruit_SSD1306.h>                   // Adafruit SSD1306 von Adafruit

#define SCREEN_WIDTH 128 												// OLED display width, in pixels
#define SCREEN_HEIGHT 64 												// OLED display height, in pixels

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
#define OLED_RESET     0 // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);


#include <MQTTClient.h>                         // MQTT von Joel Gaehwiller https://github.com/256dpi/arduino-mqtt

#include "config.h"                             // Config-Datei mit MQTT und WLAN-Zugang
#include "config_bmp.h"                         // Config-Datei mit Grafiken

void setupOTA();

const int Device_Online_FB_Address=10;					// Meldeadresse an die eine 1 gemeldet wird, sobald der µC online ist, wird automatisch über MQTT-Will auf 0 gesetzt sobald länger offline
const int Restart_SD_Address=50;                // Magnetartikeladresse über die ein Restart des µC ausgelöst wird

const int Display_Address=1;               		  // Adresse zum Durchnummerieren der Displays

#define HeartBeatPIN 2                          // Port D4 LED auf dem Wemos D1 Board, zeight ein Heart-Beat-Flacker-Signal an
#define MQTTPIN 13                              // Port D7 LED grün, leuchtet bei erfolgreicher Verbindung zum MQTT-Server
#define WIFIPIN 15                              // Port D8 LED gelb, leuchtet bei aktiver WLAN-Verbindng

const int displayRowsMax=5;
boolean displayLine = false;

String sText[displayRowsMax];

#define DELAYVAL 500

unsigned long tick;

WiFiClient net;
MQTTClient mqtt;

unsigned long lmillis;
int PauseHeartBeat=0;
byte TickHeartBeat=0;
boolean up=true;
byte Fadearray[]={
     0,  2,  4,  8, 12, 20, 32, 44, 56, 68,
    80, 92,104,116,128,140,152,164,176,188,
   200,212,224,236,255,240,210,180,150,120,
    90, 60, 40, 25, 25, 40, 60, 90,120,150,
   180,210,240,255,230,205,180,155,130,105,
    80, 55, 30, 20, 16,  8,  4,  2,  0};



void connect();
void sendSD(int SDNum, int SDState){
  //Sende Magnetartikel-Stellung an WDP
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/SD/"+String(SDNum)+"/State", String(SDState));
}
void sendTemp(int PwSenNum, float temp){
  //Sende Temperatur in °C an WDP-Boostermanagement
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/PwSen/"+String(PwSenNum)+"/T_C", String(temp));
}
void sendCurrentA(int PwSenNum, float current){
  //Sende Strom in Ampere an WDP-Boostermanagement
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/PwSen/"+String(PwSenNum)+"/I_A", String(current));
}
void sendCurrentmA(int PwSenNum, float current){
  //Sende Strom in Milli-Ampere an WDP-Boostermanagement
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/PwSen/"+String(PwSenNum)+"/I_mA", String(current));
}
void sendVoltage(int PwSenNum, float voltage){
  //Sende Spannung in Volt an WDP-Boostermanagement
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/PwSen/"+String(PwSenNum)+"/U_V", String(voltage));
}
void sendFB(int FBNum, int FBState){
  //Sende Rückmelde-Status an WDP
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/FB/"+String(FBNum)+"/State", String(FBState));
}

void resetOldValues(){
  //Status-Werte erneut senden bzw. initialiases Senden
  tick=0;
}

void printScreen(){                   // 5 Zeilen Text auf Display ausgeben
  display.clearDisplay();
  display.setTextColor(WHITE);
  display.setTextSize(1);
  for (int i=0;i<displayRowsMax;i++){
    if (sText[i].indexOf("@") == 0){  // ist das erste Zeichen ein "@", dann Zug-Grafik zeichnen
      int val = sText[i].substring(1,2).toInt();
      if (val >=4 && val <=8){
        display.drawBitmap(0, i*13, ICE1_bmp, 16, 12, 1);
        for (int n=1;n<val-1;n++){
          display.drawBitmap(n*16, i*13, ICE2_bmp, 16, 12, 1);
        }
        display.drawBitmap((val-1)*16, i*13, ICE3_bmp, 16, 12, 1);
      }
    } else{                           // ist das erste Zeichen kein "@", dann Text schreiben
      display.setCursor(0,i*13);
      display.print(sText[i]);
    }
  }
  if (displayLine){                   // Trennlinien zeichnen
    for (int i=1;i<displayRowsMax;i++){
      display.drawLine(0,i*13-3,SCREEN_WIDTH,i*13-3,WHITE);
    }
  }
  display.display();
}

void setup() {
  pinMode(MQTTPIN, OUTPUT);
  pinMode(WIFIPIN, OUTPUT);
  pinMode(HeartBeatPIN, OUTPUT);

  // SSD1306_SWITCHCAPVCC = generate display voltage from 3.3V internally
  // Wichtige Änderung: 0x3C statt 0x3D !!!!!!!!!
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // Address 0x3D for 128x64
    Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }
  for (int i=0;i<displayRowsMax;i++){ // Initiale Textwerte
    sText[i]="";
  }

  // Show initial display buffer contents on the screen --
  // the library initializes this with an Adafruit splash screen.
  display.clearDisplay();                                                                               // Logo ausgeben
  display.drawBitmap(32, 0, WDPLogo, 64, 64, 1);
  display.display();
  delay(2000); // Pause for 2 seconds

  resetOldValues();

  Serial.begin(115200);
  Serial.println();
  Serial.println("Booting...");
  WiFi.hostname(WIFI_HOSTNAME); 
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);

  mqtt.begin(host, net);
  mqtt.setKeepAlive(60);
  
  //Offline-Status via Rückmelder melden als LastWill via MQTT
  String s=String(wdpMQTTTopic)+"/Evt/FB/"+String(Device_Online_FB_Address)+"/State";
  mqtt.setWill(s.c_str(),"0",true,1);
  mqtt.onMessage(messageReceived);

  connect();
  Serial.println("Setup completed...");
}

void loop() {
  if (WiFi.status() == WL_CONNECTED) {
    ArduinoOTA.handle();
  }
  if ((tick % 100)==0){
    if (!mqtt.connected()) {
      connect();
    }
    mqtt.loop();
  }
  
  if (tick==0){
       
  }
  
  if ((tick % 100)==0){ // circa alle 100msec
      
  }
  
  if ((tick % 1000)==0){                                      //circa alle 1000msec
    if (mqtt.connected()){                                    // Aktualisierung MQTT-Status LED
      digitalWrite(MQTTPIN, HIGH); 
    } else {
      digitalWrite(MQTTPIN, LOW); 
    }
    if (WiFi.waitForConnectResult() != WL_CONNECTED){         // Aktualisierung MQTT-Status LED
      digitalWrite(WIFIPIN, LOW); 
    } else {
      digitalWrite(WIFIPIN, HIGH); 
    }

   }
  tick++;
    
    
  if (tick>=30000) tick=0;                                    // Tick-Counter zurücksetzen

  delay(1);
  //delay(30000);

  if (PauseHeartBeat<=0){                                     //Heart-Beat LED flackern lassen
    if (millis()-lmillis>=11){
      if (TickHeartBeat==58){
        PauseHeartBeat=550;
      } else {
        TickHeartBeat++;
        analogWrite(HeartBeatPIN,Fadearray[TickHeartBeat]); 
        lmillis=millis();
      }
      
    } else if (millis()<lmillis) { //wegen Überlauf
      lmillis=millis();
    }
  } else {
    PauseHeartBeat--;
    if (PauseHeartBeat==0){
      up=false;
      TickHeartBeat=0;
      TickHeartBeat++;
      analogWrite(HeartBeatPIN,Fadearray[TickHeartBeat]); 
      lmillis=millis();
    }
  }

}

void connect() {
  while(WiFi.waitForConnectResult() != WL_CONNECTED) {
    WiFi.begin(ssid, password);
    Serial.println("WiFi connection failed. Retry.");
  }

  if (WiFi.status() == WL_CONNECTED) {
    setupOTA();
  }
  
  Serial.print("Wifi connection successful - IP-Address: ");
  Serial.println(WiFi.localIP());

  if (String(mqttUser).equals("") && String(mqttPassword).equals("")){
    while (!mqtt.connect(clientid)) {
      Serial.println("Wait for MQTT-Connect");
    }    
  } else if (String(mqttPassword).equals("")){
    while (!mqtt.connect(clientid, mqttUser)) {
      Serial.println("Wait for MQTT-Connect");
    }    
  } else {
    while (!mqtt.connect(clientid, mqttUser, mqttPassword)) {
      Serial.println("Wait for MQTT-Connect");
    }    
  }

  Serial.println("MQTT connected!");

  mqtt.subscribe(String(wdpMQTTTopic)+"/#");                          //alle MQTT-Nachrichten welche mit dem wdpMQTTTopic beginnen abonnieren

  //Online-Status melden an Device_Online_FB_Address
  mqtt.publish(String(wdpMQTTTopic)+"/Evt/FB/"+String(Device_Online_FB_Address)+"/State","1",true,1 );
  
}

String getValue(String data, char separator, int index)               // Trennzeichen-getrennten String zerlegen
{
    int found = 0;
    int strIndex[] = { 0, -1 };
    int maxIndex = data.length() - 1;

    for (int i = 0; i <= maxIndex && found <= index; i++) {
        if (data.charAt(i) == separator || i == maxIndex) {
            found++;
            strIndex[0] = strIndex[1] + 1;
            strIndex[1] = (i == maxIndex) ? i+1 : i;
        }
    }
    return found > index ? data.substring(strIndex[0], strIndex[1]) : "";
}

void processSDMessage(String &Subtopic, String &payload){
    // eingehenden Magnetartikelbefehl auswerten
    if (getValue(Subtopic,'/',1).equals("State")){
      //Magnetartikeladresse
      int num=getValue(Subtopic,'/',0).toInt();
      
      //Wert, wir lassen nur Ganzzahl-Werte im Bereich -32767..32767 zu...
      float f=payload.toFloat();
      if (f>32767) f=32767;
      if (f<-32767) f=-32767;
      int value=(int)(f+.5);
      
      if (num == Restart_SD_Address){
        //ferngesteuerter Neustart des µC
        digitalWrite(MQTTPIN, LOW);
        digitalWrite(WIFIPIN, LOW);
        ESP.restart();
      }

    }
}

void processDisplayMessage(String &Subtopic, String &payload){
  // eingehenden Display-Befehl auswerten
  // Gibt die Nachricht aus welche an 'wdpMQTTTopic'/Custom/Display/num/Row/zeilenno gehen, in diesem Projekt num=1 und zeilenno=1..4

  if (getValue(Subtopic,'/',1).equals("Row")){                      //Text und Zeilennummer entgegennehmen
    //Displaynummer
    int num=getValue(Subtopic,'/',0).toInt();
    //Displayzeile
    int row=getValue(Subtopic,'/',2).toInt();

    if (num==Display_Address){
      if ((row>=1)&&(row<=displayRowsMax)){
        sText[row-1]=payload;
        printScreen();
      }
    }
 
  } else if (getValue(Subtopic,'/',1).equals("Clear")){             // Display löschen
    //Displaynummer
    int num=getValue(Subtopic,'/',0).toInt();
    if (num==Display_Address){
      for (int i=0;i<displayRowsMax;i++){                           // Initiale Textwerte
        sText[i]="";
      }
      printScreen();
    }

  } else if (getValue(Subtopic,'/',1).equals("Line")){              // Trennlinien zeichnen
    //Displaynummer
    int num=getValue(Subtopic,'/',0).toInt();
    if (num==Display_Address){
      if (payload.toInt() == 0){
        displayLine=false;
      } else {
      displayLine=true;
    }
    printScreen();
    }
  }

}

void messageReceived(String &topic, String &payload) {
  //eingehende MQTT-Nachricht auswerten, Testausgabe an seriellen Schnittstelle
  Serial.print("incoming: ");
  Serial.print(topic);
  Serial.print(" - ");
  Serial.print(payload);
  Serial.println();

  // Magnetartikel-Kommandos erkennen
  String s=String(wdpMQTTTopic)+"/Cmd/SD/";
  if (topic.startsWith(s)){
    s=topic.substring(s.length());
    processSDMessage(s,payload);
  }
  s=String(wdpMQTTTopic)+"/Custom/Display/";
  if (topic.startsWith(s)){
    s=topic.substring(s.length());
    processDisplayMessage(s,payload);
  }

  // Start einer WDP-Instanzerkennen -> neue InitTime-Meldung -> alle Werte erneut melden
  s=String(wdpMQTTTopic)+"/InitTime";
  if (topic.startsWith(s)){
    resetOldValues();
  }
  
  s=String(wdpMQTTTopic)+"/OnlineState";                            // Online Status
  if (topic.startsWith(s)){
    if (payload=="offline"){
      display.clearDisplay();
      display.drawBitmap(32, 0, WDPLogo, 64, 64, 1);
      display.display();
    }
  }

}

//vorgefertige Routine für Update des Arduino Over the Air. Passwort siehe config.h
void setupOTA(){
  // Port defaults to 8266
  // ArduinoOTA.setPort(8266);

  // Hostname defaults to esp3232-[MAC]
  ArduinoOTA.setHostname(WIFI_HOSTNAME);

  // No authentication by default
  ArduinoOTA.setPassword(OTA_PASSWORD);

  // Password can be set with it's md5 value as well
  // MD5(admin) = 21232f297a57a5a743894a0e4a801fc3
  // ArduinoOTA.setPasswordHash("21232f297a57a5a743894a0e4a801fc3");

  ArduinoOTA.onStart([]() {
    String type;
    if (ArduinoOTA.getCommand() == U_FLASH) {
      type = "sketch";
    } else { // U_FS
      type = "filesystem";
    }

    // NOTE: if updating FS this would be the place to unmount FS using FS.end()
    Serial.println("Start updating " + type);
  });
  ArduinoOTA.onEnd([]() {
    Serial.println("\nEnd");
  });
  ArduinoOTA.onProgress([](unsigned int progress, unsigned int total) {
    Serial.printf("Progress: %u%%\r", (progress / (total / 100)));
  });
  ArduinoOTA.onError([](ota_error_t error) {
    Serial.printf("Error[%u]: ", error);
    if (error == OTA_AUTH_ERROR) {
      Serial.println("Auth Failed");
    } else if (error == OTA_BEGIN_ERROR) {
      Serial.println("Begin Failed");
    } else if (error == OTA_CONNECT_ERROR) {
      Serial.println("Connect Failed");
    } else if (error == OTA_RECEIVE_ERROR) {
      Serial.println("Receive Failed");
    } else if (error == OTA_END_ERROR) {
      Serial.println("End Failed");
    }
  });
  ArduinoOTA.begin();
  
}
